package mosaic.core.detection;


import java.awt.Rectangle;
import java.text.DecimalFormat;

import org.supercsv.cellprocessor.ParseDouble;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.ift.CellProcessor;


public class Particle
{
	private	float	iX, iY, iZ;
	private	float	m0								= 0;
	private	float	m1								= 0;
	private	float	m2								= 0; 
	private	float	m3								= 0;
	private	float	m4								= 0;

	// detection stuff
	private	float	original_x						= 0;	// the originally given coordinates - not to be changed
	private	float	original_y						= 0;
	private	float	original_z						= 0;
	private	int		frame							= 0;	// the number of the frame this particle belongs to (can be 0)
	public	float	nonParticleDiscriminationScore	= 0;

	// linking stuff
	public	boolean	special							= true;	// a flag that is pused while detecting and linking particles
	public	int[]	next							= null;	// array that holds in position i the next particle number in frame i
	public	float	distance						= -1;
	public	float	lx , ly , lz;							// previous Linking x,y,z
	public	float	lxa, lya, lza;							// accumulation link
	
	/**
	 * Create a particle from another particle
	 * @param aParticle Particle
	 */
	Particle(Particle aParticle)
	{
		iX											= aParticle.iX;
		iY											= aParticle.iY;
		iZ											= aParticle.iZ;
		m0											= aParticle.m0;
		m1											= aParticle.m1;
		m2											= aParticle.m2;
		m3											= aParticle.m3;
		m4											= aParticle.m4;
		frame										= aParticle.frame;
	}

	/**
	 * @param aX - original x coordinates
	 * @param aY - original y coordinates
	 * @param aZ - original z coordinates
	 * @param aFrameNumber - the number of the frame this particle belongs to
	 * @param aLinkRange linking range
	 */
	public Particle(float aX, float aY, float aZ, int aFrameNumber)
	{
		iX											= aX;
		original_x									= aX;
		iY											= aY;
		original_y									= aY;
		iZ											= aZ;
		original_z									= aZ;

		frame										= aFrameNumber;
	}

	/**
	 * Create a default particle (needed currently by CSV, accessed via reflection)
	 */
	public Particle() {}

	/**
	 * @param rectangle of the focus area
	 */
	void translate(Rectangle focus)
	{
		iX											= iX - focus.x;
		iY											= iY - focus.y;
	}
	
	@Override
	public String toString()
	{
		return toStringBuffer().toString();
	}

	/**
	 * @return StringBuffer with this information about particle (x, y, z, m0...)
	 */
	public StringBuffer toStringBuffer()
	{
		final StringBuffer result = new StringBuffer();
		final String space = " ";

		final DecimalFormat nf = new DecimalFormat("######0.000000");
		nf.setGroupingUsed(false);

		result.append(getFrame());
		result.append(space);
		result.append(nf.format(iX));
		result.append(space);
		result.append(nf.format(iY));
		result.append(space);
		result.append(nf.format(iZ));
		result.append(space);
		result.append(nf.format(m0));
		result.append(space);
		result.append(nf.format(m1));
		result.append(space);
		result.append(nf.format(m2));
		result.append(space);
		result.append(nf.format(m3));
		result.append(space);
		result.append(nf.format(m4));
		result.append(space);
		result.append(nf.format(nonParticleDiscriminationScore));
		result.append("\n");

		return result;
	}

	public boolean match(Particle aParticle)
	{
		if (iX == aParticle.iX && 
			iY == aParticle.iY && 
			iZ == aParticle.iZ && 
			m0 == aParticle.m0 && 
			m1 == aParticle.m1 && 
			m2 == aParticle.m2 && 
			m3 == aParticle.m3 && 
			m4 == aParticle.m4) 
		{
			return true;
		}

		return false;
	}

	// ------------------------------------------------------------------------
	// CSV definitions and setters/getters used by Particle itself
	public			static final	String[]		ParticleDetection_map			= new String[]			{ "Frame", "x", "y", "z", "Size" };
	public final	static			CellProcessor[]	ParticleDetectionCellProcessor	= new CellProcessor[]	{ new ParseInt(), new ParseDouble(), new ParseDouble(), new ParseDouble(), new ParseDouble() };

	public void setFrame(int aFrameNumber)
	{
		this.frame = aFrameNumber;
	}

	public int getFrame()
	{
		return frame;
	}

	public void setOriginalX(float oX)
	{
		original_x = oX;
	}

	public float getOriginalX()
	{
		return original_x;
	}

	public void setOriginalY(float oY)
	{
		original_y = oY;
	}

	public float getOriginalY()
	{
		return original_y;
	}

	public void setOriginalZ(float oZ)
	{
		original_z = oZ;
	}

	public float getOriginalZ()
	{
		return original_z;
	}

	public void setX(float aX)
	{
		iX = aX;
	}

	public float getX()
	{
		return iX;
	}

	public void setY(float aY)
	{
		iY = aY;
	}

	public float getY()
	{
		return iY;
	}

	public void setZ(float aZ)
	{
		iZ = aZ;
	}

	public float getZ()
	{
		return iZ;
	}

	public void setM0(float aM)
	{
		m0 = aM;
	}

	public float getM0()
	{
		return m0;
	}

	public void setM1(float aM)
	{
		m1 = aM;
	}

	public float getM1()
	{
		return m1;
	}

	public void setM2(float aM)
	{
		m2 = aM;
	}

	public float getM2()
	{
		return m2;
	}

	public void setM3(float aM)
	{
		m3 = aM;
	}

	public float getM3()
	{
		return m3;
	}

	public void setM4(float aM)
	{
		m4 = aM;
	}

	public float getM4()
	{
		return m4;
	}

	public void setNonParticleDiscriminationScore(float npds)
	{
		nonParticleDiscriminationScore = npds;
	}

	public float getNonParticleDiscriminationScore()
	{
		return nonParticleDiscriminationScore;
	}
/*
	public void setSize(float aSize)
	{
		m0 = aSize;
	}

	public float getSize()
	{
		return m0;
	}

	public void setIntensity(float aIntensity)
	{
		m2 = aIntensity;
	}

	public float getIntensity()
	{
		return m2;
	}
*/
}